*Compute poverty rates

*Tim Goedemé

global place1 ...\EU-SILC\Cross\2020-04\
global place2 ...\social class and poverty\StataOutput\
global countries AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IS IT LT LU LV MT NL NO PL PT RO RS SE SI SK UK


**********************
*3 - Class structure *
**********************

mat def cats = 0\ 12 \ 36 \ 45 \ 70 \ 89 \ 100\ 0\ 50 \ 100
local varlist esec88 esec08
foreach v of local varlist {
	di "***`v'***"
	di "****************"
	cap mat drop res_`v'1
	cap mat drop res_`v'2
	
	foreach ctry of global countries {
		di "`ctry'"
		
		quietly {
			
			if "`v'"=="esec88" {
				forvalues year=2004(1)2011 {
					noi di "`year'", _continue
					cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_analysis.dta"
					if _rc==0 {
						cap mat drop tempmat1
						use "${place1}\`ctry'\\`year'\c`ctry'`year'_analysis.dta", clear
						
						svyset psu1 [pw=rb050], strata(strata1)
						*note that we do not use pb040 in this case (to make sure all estimates are consistent with those for the total population)

						qui: ta `v'
						if r(r)==9 {
						    
							qui: gen sub = (active==1 & actage==1 & resp==1 & `v')
							qui: replace `v'=0 if sub==0
							
							qui: replace `v' = 12 if `v'==1 | `v'==2
							qui: replace `v' = 36 if `v'==3 | `v'==6
							qui: replace `v' = 45 if `v'==4 | `v'==5
							qui: replace `v' = 70 if `v'==7
							qui: replace `v' = 89 if `v'==8 | `v'==9
							
							qui: ifgt1 hystd, alpha(0) hgroup(`v') opl(median) prop(60)
							mat def tempmat1 = e(ifgt1)

							qui: ifgt1 hystd, alpha(0) hgroup(sub) opl(median) prop(60)
							mat def tempmat1 = tempmat1 \ e(ifgt1)
							
							mat def tempmat1 = tempmat1, cats

							local r=rowsof(tempmat1) - 1
							local jaren `year'
							local names `ctry'
							forvalues x=1/`r' {
								local jaren `jaren' \ `year'
								local names `names' `ctry'
							}
							mat def ymat = `jaren'
							
							mat def tempmat1 = tempmat1, ymat
							mat rownames tempmat1 = `ctry'
							mat def res_`v'1 = nullmat(res_`v'1) \ tempmat1
						}
					}
				}
			
			}
			
			else {
				forvalues year=2010(1)2018 {
					noi di "`year'", _continue
					cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
					
					if _rc==0 {
					use "${place1}\`ctry'\\`year'\c`ctry'`year'_analysis.dta", clear
						cap mat drop tempmat1
						svyset psu1 [pw=rb050], strata(strata1)
						
						qui: ta `v'
						if r(r)==9 {
							qui: gen sub = (active==1 & actage==1 & resp==1)
							qui: replace `v'=0 if sub==0
							qui: replace `v' = 12 if `v'==1 | `v'==2
							qui: replace `v' = 36 if `v'==3 | `v'==6
							qui: replace `v' = 45 if `v'==4 | `v'==5
							qui: replace `v' = 70 if `v'==7
							qui: replace `v' = 89 if `v'==8 | `v'==9

							qui: ifgt1 hystd, alpha(0) hgroup(`v') opl(median) prop(60)
							mat def tempmat1 = e(ifgt1)

							qui: ifgt1 hystd, alpha(0) hgroup(sub) opl(median) prop(60)
							mat def tempmat1 = tempmat1 \ e(ifgt1)
							
							mat def tempmat1 = tempmat1, cats

							local r=rowsof(tempmat1) - 1
							local jaren `year'
							forvalues x=1/`r' {
								local jaren `jaren' \ `year'
							}
							mat def ymat = `jaren'
							
							mat def tempmat1 = tempmat1, ymat
							mat rownames tempmat1 = `ctry'
							mat def res_`v'1 = nullmat(res_`v'1) \ tempmat1
						}
							
					}
				}
			}
		}
	}
}

*Export data
local varlist esec88 esec08
foreach v of local varlist {
	di "***`v'***"
	global names: rownames res_`v'1
	clear
	mat colnames res_`v'1 = Estimate STE DF LB UB Povline category year
	svmat res_`v'1, names(col)
	gen country=""
	local counter
	foreach r of global names {
	    local counter=`counter'+1
	    replace country="`r'" in `counter'
	}
	gen esec="`v'"
	compress
	save "${place2}\AROP60res_`v'_5.dta", replace
}

*Rearrange and create graphs
*****************************
*1/ Poverty rates by social class in 2018
use "${place2}\AROP60res_esec08_5.dta", clear
gen CIarm = UB-Estimate
keep if year==2018
drop if category==0 | category==100

encode country, gen(countryNR)
drop DF LB UB Povline STE
reshape wide Estimate CIarm, i(country) j(category)
order _all, seq
order country esec year


**************************************************************************************
*Recompute poverty for farmers in RO and PL, including production for own consumption*
**************************************************************************************

* Toevoegen nieuwe variabelen
global countries PL RO


foreach ctry of global countries {
	di "`ctry'", _continue

	forvalues year=2018(1)2018 {
		di "`ctry': `year'"
		cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
		
		if _rc==0 {
		    quietly {
				use "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta", clear
				if `year'<2009 keep country year hid pid pl030 px040
				else keep country year hid pid pl031
				cap drop _merge
				merge 1:1 country year pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_ESEC.dta"
				cap drop _merge
				drop emp*
				merge 1:1 country hid pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta", keepusing(active actage hystd1)
				cap drop _merge
				
				gen resp = (px040==1 | px040==2)
				
				compress
				save "${place1}\`ctry'\\`year'\c`ctry'`year'_analysis.dta", replace
			}
		}
	}
}

* 9 classes

mat def cats = 0\ 1\ 2\ 3\ 4\ 5\ 6\ 7\ 8\ 9\ 100\ 0\ 50 \ 100
local varlist esec08
foreach v of local varlist {
	di "***`v'***"
	di "****************"
	cap mat drop res_`v'1
	cap mat drop res_`v'2
	
	foreach ctry of global countries {
		di "`ctry'"
		
		quietly {
				forvalues year=2018(1)2018 {
					noi di "`year'", _continue
					cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
					
					if _rc==0 {
						use "${place1}\`ctry'\\`year'\c`ctry'`year'_analysis.dta", clear
						cap mat drop tempmat1
						svyset psu1 [pw=rb050], strata(strata1)
						
						qui: ta `v'
						if r(r)==9 {
							qui: gen sub = (active==1 & actage==1 & resp==1)
							replace `v'=0 if sub==0

							qui: ifgt1 hystd1, alpha(0) hgroup(`v') opl(median) prop(60)
							mat def tempmat1 = e(ifgt1)

							qui: ifgt1 hystd1, alpha(0) hgroup(sub) opl(median) prop(60)
							mat def tempmat1 = tempmat1 \ e(ifgt1)
							
							mat def tempmat1 = tempmat1, cats

							local r=rowsof(tempmat1) - 1
							local jaren `year'
							forvalues x=1/`r' {
								local jaren `jaren' \ `year'
							}
							mat def ymat = `jaren'
							
							mat def tempmat1 = tempmat1, ymat
							mat rownames tempmat1 = `ctry'
							mat def res_`v'1 = nullmat(res_`v'1) \ tempmat1
					}
				}
			}
		}
	}
}

*Export data
local varlist esec08
foreach v of local varlist {
	di "***`v'***"
	global names: rownames res_`v'1
	clear
	mat colnames res_`v'1 = Estimate STE DF LB UB Povline category year
	svmat res_`v'1, names(col)
	gen country=""
	local counter
	foreach r of global names {
	    local counter=`counter'+1
	    replace country="`r'" in `counter'
	}
	gen esec="`v'"
	compress
	save "${place2}\AROP601res_`v'.dta", replace
}

*Rearrange and create graphs
*****************************
*1/ Poverty rates by social class in 2018
use "${place2}\AROP601res_esec08.dta", clear
gen CIarm = UB-Estimate
keep if year==2018
keep if category>0 & category<=50
encode country, gen(countryNR)
drop DF LB UB Povline STE
reshape wide Estimate CIarm, i(country) j(category)
order _all, seq
order country esec year


*5 classes

mat def cats = 0\ 12 \ 36 \ 45 \ 70 \ 89 \ 100\ 0\ 50 \ 100
local varlist esec08
foreach v of local varlist {
	di "***`v'***"
	di "****************"
	cap mat drop res_`v'1
	cap mat drop res_`v'2
	
	foreach ctry of global countries {
		di "`ctry'"
		
		quietly {

				forvalues year=2018(1)2018 {
					noi di "`year'", _continue
					cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
					
					if _rc==0 {
					use "${place1}\`ctry'\\`year'\c`ctry'`year'_analysis.dta", clear
						cap mat drop tempmat1
						svyset psu1 [pw=rb050], strata(strata1)
						
						qui: ta `v'
						if r(r)==9 {
							qui: gen sub = (active==1 & actage==1 & resp==1)
							qui: replace `v'=0 if sub==0
							qui: replace `v' = 12 if `v'==1 | `v'==2
							qui: replace `v' = 36 if `v'==3 | `v'==6
							qui: replace `v' = 45 if `v'==4 | `v'==5
							qui: replace `v' = 70 if `v'==7
							qui: replace `v' = 89 if `v'==8 | `v'==9

							qui: ifgt1 hystd1, alpha(0) hgroup(`v') opl(median) prop(60)
							mat def tempmat1 = e(ifgt1)

							qui: ifgt1 hystd1, alpha(0) hgroup(sub) opl(median) prop(60)
							mat def tempmat1 = tempmat1 \ e(ifgt1)
							
							mat def tempmat1 = tempmat1, cats

							local r=rowsof(tempmat1) - 1
							local jaren `year'
							forvalues x=1/`r' {
								local jaren `jaren' \ `year'
							}
							mat def ymat = `jaren'
							
							mat def tempmat1 = tempmat1, ymat
							mat rownames tempmat1 = `ctry'
							mat def res_`v'1 = nullmat(res_`v'1) \ tempmat1
						
							
					}
				}
			}
		}
	}
}

*Export data
local varlist esec08
foreach v of local varlist {
	di "***`v'***"
	global names: rownames res_`v'1
	clear
	mat colnames res_`v'1 = Estimate STE DF LB UB Povline category year
	svmat res_`v'1, names(col)
	gen country=""
	local counter
	foreach r of global names {
	    local counter=`counter'+1
	    replace country="`r'" in `counter'
	}
	gen esec="`v'"
	compress
	save "${place2}\AROP601res_`v'_5.dta", replace
}

*rearrange the data
use "${place2}\AROP601res_esec08_5.dta", clear
gen CIarm = UB-Estimate
keep if year==2018
drop if category==0 | category==100

encode country, gen(countryNR)
drop DF LB UB Povline STE
reshape wide Estimate CIarm, i(country) j(category)
order _all, seq
order country esec year

***********************************************
*Re-arrange the data to track trends over time*
***********************************************

*complete trends by country

local varlist esec88 esec08
foreach v of local varlist {
	use "${place2}\AROP60res_`v'_5.dta", clear
	gen CIarm = UB-Estimate
	drop if category==0 | category==100

	encode country, gen(countryNR)
	drop DF LB UB Povline STE
	reshape wide Estimate CIarm, i(country year) j(category)
	order _all, seq
	order country esec year
	
	save "${place2}\AROP60res_`v'_5fig.dta", replace
}

append using "${place2}\AROP60res_esec88_5fig.dta"
drop CIarm50 Estimate50
order country esec year Estimate* CIarm*

gen period2 = (esec=="esec08")
sort country period2 year

*difference in 2011

keep if year==2011
drop countryNR

reshape wide Estimate* CIarm* esec, i(country) j(period2)

local cats 12 36 45 70 89
foreach cat of local cats {
	gen dif`cat' = Estimate`cat'1 - Estimate`cat'0

}

browse country dif*
















use "${place2}\AROP60res_esec08.dta", clear
keep if year==2018

keep if category==50

reshape wide Estimate, i(country year) j(esec88)
	set scheme  s1mono
		graph twoway line EST year if categ==5005 & earnings==`earn' & class==1 & country=="`ctry'" & esec==883, lcolor(black) ///
			xlabel( , labsize(large)) ylabel( , labsize(large)) xtitle("Year", size(large)) ytitle("") ///
			title("Real growth of gross ${title} by social class in `ctry'", size(large)) ///
			|| line EST year if categ==5005 & earnings==`earn' & class==1 & country=="`ctry'" & esec==83, ylab(`low'(10)`high', grid) yline(`low'(5)`high', lcolor(gs10)) lcolor(black) ///
			|| line EST year if categ==5005 & earnings==`earn' & class==2 & country=="`ctry'" & esec==883, lcolor(black)  ///
			|| line EST year if categ==5005 & earnings==`earn' & class==2 & country=="`ctry'" & esec==83, lcolor(black)  ///
			|| line EST year if categ==5005 & earnings==`earn' & class==3 & country=="`ctry'" & esec==883, lcolor(black)  ///
			|| line EST year if categ==5005 & earnings==`earn' & class==3 & country=="`ctry'" & esec==83, lcolor(black) ///
			|| rcap LB UB year if categ==5005 & earnings==`earn' & class==1 & country=="`ctry'" & esec==883, lcolor(black) ///
			|| rcap LB UB year if categ==5005 & earnings==`earn' & class==1 & country=="`ctry'" & esec==83, lcolor(black) ///
			|| rcap LB UB year if categ==5005 & earnings==`earn' & class==2 & country=="`ctry'" & esec==883, lcolor(black) ///
			|| rcap LB UB year if categ==5005 & earnings==`earn' & class==2 & country=="`ctry'" & esec==83, lcolor(black) ///
			|| rcap LB UB year if categ==5005 & earnings==`earn' & class==3 & country=="`ctry'" & esec==883, lcolor(black) ///
			|| rcap LB UB year if categ==5005 & earnings==`earn' & class==3 & country=="`ctry'" & esec==83, lcolor(black) ///
			|| scatter EST year if categ==5005 & earnings==`earn' & class==1 & country=="`ctry'" & esec==883, ms(O) mcolor(gs0) legend(order(13 15 17) label(13 "Upper class") size(large)) ///
			|| scatter EST year if categ==5005 & earnings==`earn' & class==1 & country=="`ctry'" & esec==83, ms(O)  mcolor(gs0) ///
			|| scatter EST year if categ==5005 & earnings==`earn' & class==2 & country=="`ctry'" & esec==883, ms(S) mcolor(gs7) msize(medium) legend(order(13 15 17) label(15 "Intermediate class") size(large)) ///
			|| scatter EST year if categ==5005 & earnings==`earn' & class==2 & country=="`ctry'" & esec==83, ms(S)  mcolor(gs7) msize(medium) ///
			|| scatter EST year if categ==5005 & earnings==`earn' & class==3 & country=="`ctry'" & esec==883, ms(D) mcolor(gs0) msize(medsmall) legend(order(13 15 17) label(17 "Working class") size(large)) ///
			|| scatter EST year if categ==5005 & earnings==`earn' & class==3 & country=="`ctry'" & esec==83, ms(D)  mcolor(gs0) msize(medsmall)

			
		graph export "${place3}\Growthindex_`ctry'_earn`earn'_CI.emf", replace


